/** @file   LightBeamCell.cpp
 * @brief   Implementation of LightBeamCell class
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/08/13 10:50:22 $
 * @author  Tomi Lamminsaari
 */
 
#include "LightBeamCell.h"
#include <allegro.h>
#include "MMapAccessInterface.h"

namespace WeWantWar {
    
LightBeamCell::LightBeamCell( const eng2d::Vec2D& aPos, float aBrightness, float aCellSize,
                              int aColor ) :
  iPosition( aPos ),
  iOriginalBrightness( aBrightness ),
  iOriginalColor(aColor),
  iDynamicBrightness( 0 ),
  iCellSize( aCellSize )
{
}

LightBeamCell::~LightBeamCell()
{
}

void LightBeamCell::update(const eng2d::Vec2D& aOrigin,
                           const MMapAccessInterface& aMapAccess,
                           float aDirection )
{
  eng2d::Vec2D cellPos = iPosition;
  cellPos.rotate( aDirection );
  cellPos += aOrigin;
      
  iDynamicBrightness = iOriginalBrightness;
  iDynamicColor = iOriginalColor;
  if ( aMapAccess.bulletCollision(cellPos) == true ) {
      iDynamicBrightness /= 2;
  }
  
  eng2d::Vec2D distV = cellPos - aOrigin;
  float distance = distV.length();
  int stepsToGo = static_cast<int>(distance / iCellSize);
  eng2d::Vec2D stepVec = distV;
  stepVec.norm();
  stepVec *= iCellSize;
  
  cellPos -= stepVec;
  int stopIterating = 2;
  int r = getr( iOriginalColor );
  int g = getg( iOriginalColor );
  int b = getb( iOriginalColor );
  
  for ( int i=0; i < stepsToGo; i++ ) {
    if ( stopIterating == 0 ) {
      iDynamicColor = 0;
      break;
    }
    if ( aMapAccess.bulletCollision(cellPos) == true ) {
        stopIterating -= 1;
        r = r>>1;
        g = g>>1;
        b = b>>1;
        iDynamicColor = makecol(r,g,b);
    }
    cellPos -= stepVec;
  }
}

void LightBeamCell::renderBrightness( BITMAP* aCanvas, const eng2d::Vec2D& aOrigin ) const
{
  int posX = iPosition.intX() + aOrigin.intX();
  int posY = iPosition.intY() + aOrigin.intY();
  int halfCell = static_cast<int>( iCellSize ) / 2;

  rectfill( aCanvas, posX - halfCell, posY - halfCell,
                     posX + halfCell, posY + halfCell,
                     iDynamicColor );
}

eng2d::Vec2D LightBeamCell::cellPosition() const
{
  return iPosition;
}

}  // end of namespace
